#!/usr/bin/env bash
web_port=30001
core_port=8443
SHELL_FOLDER=$(cd "$(dirname "$0")";pwd)
                                                                                                                        
                                                                                                                        
echo "                                                                                                                        

                                                                                                                        
                                                                                                                        
           !@@@@@@@@@@@@@@@~                                                                                            
          !@@@@@@@@@@@@@@@@@@             #@@@@@@@@@@@@@        =@@@@                         !@@@@@,                   
          @@@@@@@@@@@@@@@@@@@@            @@@@@@@@@@@@@!       ;@@@@@@                      @@@@@@@@,                   
            @@@@@@@@   =@@@@@@@             @@@@@@@@!,        @@@@@@@                     ,@@@@@@@@.                   
            @@@@@@@@    @@@@@@@!             @@@@@@@           @@@@@@:                        @@@@@@.                   
            @@@@@@@@     @@@@@@@             @@@@@@@          ;@@@@@.                         @@@@@@.                   
            @@@@@@@@     :@@@@@@@            @@@@@@@                                          @@@@@@.                   
            @@@@@@@@      @@@@@@@~           @@@@@@@              !@@       @@!     ;@@!      @@@@@@.    #@@@@@@,       
            @@@@@@@@      .@@@@@@@           @@@@@@@          .@@@@@@    @@@@@@   @@@@@@@     @@@@@@.   @@@@@@@:        
            @@@@@@@@       @@@@@@@;          @@@@@@@          @@@@@@@   @@@@@@@-@@@@@@@@@     @@@@@@   @@@@@@           
            @@@@@@@@        @@@@@@@ @@@@@@@  @@@@@@@          .@@@@@@   ,@@@@@@@@@@@@@@@@     @@@@@@. @@@@@@            
            @@@@@@@@       .@@@@@@@ @@@@@@@  @@@@@@@            @@@@@    @@@@@@@.  .@@@@@     @@@@@@.@@@@@@.            
            @@@@@@@@       @@@@@@@  @@@@@@@  @@@@@@@            @@@@@    @@@@@@     @@@@@     @@@@@@@@@@@@!             
            @@@@@@@@       @@@@@@@  #######  @@@@@@@      ;@$   @@@@@    @@@@@@     @@@@@     @@@@@@@@@@@@!             
            @@@@@@@@      @@@@@@@.           @@@@@@@      @@$   @@@@@    @@@@@@     @@@@@     @@@@@@@@@@@@@-            
            @@@@@@@@     #@@@@@@@            @@@@@@@     @@@$   @@@@@    @@@@@@     @@@@@     @@@@@@-@@@@@@@            
            @@@@@@@@    ~@@@@@@@             @@@@@@@     @@@$   @@@@@    @@@@@@     @@@@@     @@@@@@, @@@@@@@           
            @@@@@@@@    @@@@@@@@             @@@@@@@     @@@$   @@@@@    @@@@@@     @@@@@     @@@@@@,  @@@@@@@.         
          -@@@@@@@@@@@@@@@@@@@@              @@@@@@@@*!@@@@@$  /@@@@@@   @@@@@@.    @@@@@@    @@@@@@@-  @@@@@@@@-       
          @@@@@@@@@@@@@@@@@@@@~           @@@@@@@@@@@@@@@@@@$ @@@@@@@@@ @@@@@@@@@   @@@@@@@ @@@@@@@@@@   @@@@@@@@@      
         ;@@@@@@@@@@@@@@@@@@.            @@@@@@@@@@@@@@@@@@@/ @@@@@@@@@ @@@@@@@@@    #@@@@# @@@@@@@@@@    :@@@@@@.      
                                                                                                                        
                                                                                                                        "

echo "########## Welcome use Nuclias Connect ###########"
echo "                     --                           "
echo "                     --                           "
echo "                     --                           "
echo -e "\033[36m(1/11)---- check your system type ----\033[0m"
if [ "$(uname)" = "Darwin" ]
	then SYS="OS X"
	echo -e "\033[0mThe installation process is canceled because the current OS is not CentOS or Ubuntu. Remind you to use CentOS 8.3.2011 or Ubuntu 20.04.1 LTS or a later version \033[0m"
	exit 1	
elif [ "$(expr substr $(uname -s) 1 5)" = "Linux" ]; then
	SYS="Linux"
    if grep -Eqii "CentOS" /etc/issue || grep -Eq "CentOS" /etc/*-release; then
        DISTRO='CentOS'
		Check_Versions=`sudo cat /etc/*-release |grep "CentOS Linux release"|head -1|cut -c 22-29`
		if [ `expr $Check_Versions \< 8.3.2011` -eq 1 ]
			then
				echo -e "\033[32mThe current version of CentOS is $Check_Versions which is lower than required. Remind you to upgrade the system to 8.3.2011 before you start again. Would you like to continue the installation? [y/n] \033[0m"
				read k
				if [ "$k" = "n" ]
					then
					echo -e "\033[0mThe installation process is canceled,remind you to upgrade 8.3.2011 before you start again. \033[0m"
					exit 1		
				fi
		fi
#        firewall-cmd --zone=public --add-port=$web_port/tcp --permanent
#        firewall-cmd --zone=public --add-port=$core_port/tcp --permanent
#        firewall-cmd --reload
    elif grep -Eqi "Red Hat Enterprise Linux Server" /etc/issue || grep -Eq "Red Hat Enterprise Linux Server" /etc/*-release; then
        DISTRO='RHEL'
		echo -e "\033[0mThe installation process is canceled because the current OS is not CentOS or Ubuntu. Remind you to use CentOS 8.3.2011 or Ubuntu 20.04.1 LTS or a later version \033[0m"
		exit 1
    elif grep -Eqi "Aliyun" /etc/issue || grep -Eq "Aliyun" /etc/*-release; then
        DISTRO='Aliyun'
		echo -e "\033[0mThe installation process is canceled because the current OS is not CentOS or Ubuntu. Remind you to use CentOS 8.3.2011 or Ubuntu 20.04.1 LTS or a later version \033[0m"
		exit 1
    elif grep -Eqi "Fedora" /etc/issue || grep -Eq "Fedora" /etc/*-release; then
        DISTRO='Fedora'
		echo -e "\033[0mThe installation process is canceled because the current OS is not CentOS or Ubuntu. Remind you to use CentOS 8.3.2011 or Ubuntu 20.04.1 LTS or a later version \033[0m"
		exit 1
    elif grep -Eqi "Debian" /etc/issue || grep -Eq "Debian" /etc/*-release; then
        DISTRO='Debian'
		echo -e "\033[0mThe installation process is canceled because the current OS is not CentOS or Ubuntu. Remind you to use CentOS 8.3.2011 or Ubuntu 20.04.1 LTS or a later version \033[0m"
		exit 1
#        iptables -A INPUT -p tcp --dport $web_port -j ACCEPT
#        iptables -A INPUT -p tcp --dport $core_port -j ACCEPT
    elif grep -Eqi "Ubuntu" /etc/issue || grep -Eq "Ubuntu" /etc/*-release; then
        DISTRO='Ubuntu'
		Check_Versions=`sudo cat /etc/*-release |grep DISTRIB_RELEASE |cut -c 17-21`
		if [ `expr $Check_Versions \< 20.04.1` -eq 1 ]
			then
				echo -e "\033[32mThe current version of Ubuntu is $Check_Versions which is lower than required. Remind you to upgrade the system to 20.04.1 LTS or a later version before you start again. Would you like to continue the installation? [y/n] \033[0m"
				read k
				if [ "$k" = "n" ]
					then
					echo -e "\033[0mThe installation process is canceled,remind you to upgrade 20.04.1 LTS or a later version before you start again. \033[0m"
					exit 1		
				fi
		fi
#        ufw allow $web_port/tcp
#        ufw allow $core_port/tcp
#        ufw reload
    elif grep -Eqi "Raspbian" /etc/issue || grep -Eq "Raspbian" /etc/*-release; then
        DISTRO='Raspbian'
		echo -e "\033[0mThe installation process is canceled because the current OS is not CentOS or Ubuntu. Remind you to use CentOS 8.3.2011 or Ubuntu 20.04.1 LTS or a later version \033[0m"
		exit 1
    else
        DISTRO='unknow'
		echo -e "\033[0mThe installation process is canceled because the current OS is not CentOS or Ubuntu. Remind you to use CentOS 8.3.2011 or Ubuntu 20.04.1 LTS or a later version \033[0m"
		exit 1
    fi
elif [ "$(expr substr $(uname -s) 1 10)" = "MINGW32_NT" ]; then
	SYS="WIN"
	echo -e "\033[0mThe installation process is canceled because the current OS is not CentOS or Ubuntu. Remind you to use CentOS 8.3.2011 or Ubuntu 20.04.1 LTS or a later version \033[0m"
	exit 1
fi
echo "SYSTEM：$SYS $DISTRO"
echo -e "\033[32mcheck system finished\033[0m"

#2021/0623 DCP
echo -e "\033[36m(2/11)---- check docker service ----\033[0m"
Install_docker_ubuntu()
{
sudo apt-get update
sudo apt-get install \
    apt-transport-https \
    ca-certificates \
    curl \
    gnupg-agent \
    software-properties-common
sudo curl -fsSL https://download.docker.com/linux/ubuntu/gpg | sudo apt-key add -
sudo add-apt-repository \
"deb [arch=amd64] https://download.docker.com/linux/ubuntu \
$(lsb_release -cs) \
stable"
sudo apt-get update
sudo apt-get install docker-ce docker-ce-cli containerd.io	
sudo systemctl enable docker
check_docker=`docker -v`
if [ "$check_docker" ] 
	then 
	echo -e "\033[32mdocker installation is complete\033[0m"
	echo -e "\033[32m$check_docker\033[0m"
fi
}

Install_docker_centos()
{
sudo yum install -y yum-utils
sudo yum-config-manager \
    --add-repo \
    https://download.docker.com/linux/centos/docker-ce.repo
sudo yum install docker-ce docker-ce-cli containerd.io
sudo systemctl start docker
sudo systemctl enable docker
check_docker=`docker -v`
if [ "$check_docker" ] 
	then 
	echo -e "\033[32mdocker installation is complete\033[0m"
	echo -e "\033[32m$check_docker\033[0m"
fi
}

Install_docker_compose()
{
sudo curl -L "https://github.com/docker/compose/releases/download/1.29.2/docker-compose-$(uname -s)-$(uname -m)" -o /usr/local/bin/docker-compose
sudo chmod +x /usr/local/bin/docker-compose
sudo ln -s /usr/local/bin/docker-compose /usr/bin/docker-compose
docker-compose --version
check_docker_compose=`docker-compose -v`
if [ "$check_docker_compose" ]
	then 
	echo -e "\033[32mdocker-compose installation is complete\033[0m"
	echo -e "\033[32m$check_docker_compose\033[0m"
fi		
}

check_docker_service()
{
check_docker=`sudo docker -v`
if [ "$check_docker" ] 
	then 
	docker_status="found docker"
else
	docker_status="No found docker"
fi


check_docker_compose=`docker-compose -v`
if [ "$check_docker_compose" ]
	then 
	docker_compose_status="found docker-compose"
else
	docker_compose_status="No found docker-compose"
fi


check_docker_status=`ps -fe | grep dockerd | wc -l`
if [ $check_docker_status -eq 1 ]
	then 
	docker_service_status="docker service not running"
else
	docker_service_status="docker service is running"
fi
echo -e "$check_docker\n$docker_compose_status\n$docker_service_status."
}

Install_service()
{
if [ "$docker_status" = "No found docker" ] || [ "$docker_compose_status" = "No found docker-compose" ] || [ "$docker_service_status" = "docker service not running" ]
	then echo -e "\033[32mSome of the necessary docker service packages haven't been installed yet, the system will help you to install them, please make sure your system is connected to the internet. Would you like to continue the installation? [y/n] \033[0m"
	read k
	if [ "$k" = "n" ]
		then
		echo -e "\033 [The installation process is canceled, remind you to upgrade the system to the required version and install the necessary packages before starting again. \033[0m"
                exit 1
	else
		if [ "$docker_status" = "No found docker" ]
			then
			echo -e "\033[32mStart installation docker \033[0m"
			if [ "$DISTRO" = "Ubuntu" ] 
				then
				Install_docker_ubuntu
				if [ "$docker_compose_status" = "No found docker-compose" ]
					then
					echo -e "\033[32mStart installation docker-compose \033[0m"
					Install_docker_compose
					if [ "$docker_service_status" = "docker service not running" ]
						then
						echo -e "\033[32mOpen docker service \033[0m"
						count=0
						while [ $check_docker_status -eq 1 ] && [ !$count = 3 ]
						do
							count=$((count+1))
							sudo systemctl start docker
						done
						if [ $check_docker_status -eq 1 ]
							then
							echo -e "\033[32mInstall docker service \033[0m"
							Install_docker_ubuntu
						fi
					fi
				fi
			elif [ "$DISTRO" = "CentOS" ]; 
				then	
				Install_docker_centos
				if [ "$docker_compose_status" = "No found docker-compose" ]
					then
					echo -e "\033[32mStart installation docker-compose \033[0m"
					Install_docker_compose
					if [ "$docker_service_status" = "docker service not running" ]
						then
						echo -e "\033[32mOpen docker service \033[0m"
						count=0
                                                while [ $check_docker_status -eq 1 ] && [ !$count = 3 ]
                                                do
                                                        count=$((count+1))
                                                        sudo systemctl start docker
                                                done
                                                if [ $check_docker_status -eq 1 ]
                                                        then
							echo -e "\033[32mInstall docker service \033[0m"
                                                        Install_docker_ubuntu
                                                fi

					fi
				fi
			fi	
		elif [ "$docker_compose_status" = "No found docker-compose" ];
			then 
			echo -e "\033[32mStart installation docker-compose \033[0m"
			Install_docker_compose
			if [ "$docker_service_status" = "docker service not running" ]
				then
				echo -e "\033[32mOpen docker service \033[0m"
				count=0
                                while [ $check_docker_status -eq 1 ] && [ $count != 3 ]
                                do
        	                        count=$((count+1))
					sudo systemctl start docker
                                done
                                if [ $check_docker_status -eq 1 ]
                        	        then
					echo -e "\033[32mInstall docker service \033[0m"
                                        Install_docker_ubuntu
                                fi
			fi
		elif [ "$docker_service_status" = "docker service not running" ];
			then
			echo -e "\033[32mOpen docker service \033[0m"
			count=0
                        while [ $check_docker_status -eq 1 ] && [ $count != 3 ]
                        do
				count=$((count+1))
                                sudo systemctl start docker
                        done
                        if [ $check_docker_status -eq 1 ]
                        	then
				echo -e "\033[32mInstall docker service \033[0m"
                                Install_docker_ubuntu
                        fi
		fi
	fi
fi
}

Judge_docker()
{
if [ "$docker_status" = "No found docker" ] || [ "$docker_compose_status" = "No found docker-compose" ] || [ "$docker_service_status" = "docker service not running" ]
	then echo "Judge_success"
fi
}


check_docker_service
while [ "$docker_status" = "No found docker" ] || [ "$docker_compose_status" = "No found docker-compose" ] || [ "$docker_service_status" = "docker service not running" ]
do
	Install_service
	check_docker_service
done




#Uninstall automatically
echo -e "\033[36m(3/11)---- Uninstall the version ----\033[0m"
Check_web_versions=`sudo docker images|grep nuclias/nuclias_connect_web | awk '{print $2}' | head -n 1`
Check_core_versions=`sudo docker images|grep nuclias/nuclias_connect_core | awk '{print $2}' | head -n 1`
if [[ $Check_web_versions || $Check_core_versions ]]
	then
		Check_versions=$Check_web_versions
		if [[ $Check_web_versions != '' ]]
			then 
				Check_versions=$Check_web_versions
		else
			Check_versions=$Check_core_versions
		fi	
		echo -e "\033[32mNuclias Connect $Check_versions has been installed.  
If you are going to reinstall it, remind you to back up the existing configuration file before starting. 
Would you like to continue the installation? [y/n] \033[0m"
	
		read k
		if [ "$k" = "n" ]
			then		
				echo -e "\033 [The installation process is canceled,please back up the existing configuration file you start again. \033[0m"
				exit 1	
		else
			echo "Please wait..."	
			echo "message: $check_container_web_id"
			check_container_web_id=`sudo docker ps -a |grep nuclias/nuclias_connect_web |cut -c 1-12|wc -l`
			if [ $check_container_web_id -eq 1 ]
				then
				echo "start delete web"			
				container_web_id=`sudo docker ps -a |grep nuclias/nuclias_connect_web |cut -c 1-12`			
				sudo docker stop $container_web_id 
				sudo docker rm $container_web_id
			fi
			
			echo "message: $check_container_core_id"
			check_container_core_id=`sudo docker ps -a |grep nuclias/nuclias_connect_core |cut -c 1-12|wc -l`
			if [ $check_container_core_id -eq 1 ]
				then
				echo "start delete core"					
				container_core_id=`sudo docker ps -a |grep nuclias/nuclias_connect_core |cut -c 1-12`
				sudo docker stop $container_core_id 		
				sudo docker rm $container_core_id		
			fi
			
			check_container_postgredb_id=`sudo docker ps -a |grep postgres:16.1 |cut -c 1-12|wc -l`
			echo "message: $check_container_postgredb_id"
			if [ $check_container_postgredb_id -eq 1 ]
				then
				echo "start delete mognodb"					
				container_core_id=`sudo docker ps -a |grep postgres:16.1 |cut -c 1-12`
				sudo docker stop $container_core_id 		
				sudo docker rm $container_core_id		
			fi
			
			docker-compose down
			#Stop DNC service		 	

			check_image_core=`sudo docker images nuclias/nuclias_connect_core:$Check_versions | wc -l`
			check_image_web=`sudo docker images nuclias/nuclias_connect_web:$Check_versions | wc -l`
			echo "message: $check_image_core"
			if [ $check_image_core -eq 2 ]
				then echo "start uninstall core image"
				sudo docker rmi nuclias/nuclias_connect_core:$Check_versions #Delete core images
			else
				echo "No older versions of nuclias_connect_core image found"
			fi

			echo "message: $check_image_web"
			if [ $check_image_web -eq 2 ]
				then echo "start uninstall web image"
				sudo docker rmi nuclias/nuclias_connect_web:$Check_versions  #Delete web images
			else
				echo "No older versions of nuclias_connect_web image found"
			fi
				echo -e "\033[32mHas been completed\033[0m"
		fi
else
echo -e "\033[32mNo version installation detected \033[0m"
fi



#Modified by DengCP


echo -e "\033[36m(4/11)---- check core image ----\033[0m"
check_image_core=`sudo docker images nuclias/nuclias_connect_core | wc -l`
echo "message: $check_image_core"
if [ $check_image_core -eq 1 ]
	then echo "start down core image"
	if [ ! -f $SHELL_FOLDER"/images/core.tar" ]
		then echo -e "\033[31m not found core image\033[0m"
	exit 1
	fi
	load_core=`sudo docker load < $SHELL_FOLDER/images/core.tar`
fi
echo -e "\033[32mcore image is existed\033[0m"


echo -e "\033[36m(5/11)---- check web image ----\033[0m"
check_image_web=`sudo docker images nuclias/nuclias_connect_web | wc -l`
echo "message: $check_image_web"
if [ $check_image_web -eq 1 ]
	then echo "start down web image"
	if [ ! -f $SHELL_FOLDER"/images/web.tar" ]
		then echo -e "\033[31m not found core image\033[0m"
		exit 1
	fi
	load_web=`sudo docker load < $SHELL_FOLDER/images/web.tar`
fi
echo -e "\033[32mweb image is existed\033[0m"


echo -e "\033[36m(6/11)---- check old DB ----\033[0m"
check_running_container_postgre=`sudo docker ps -a|grep postgres:16.1|wc -l`
check_running_container_postgre_dncSP=`sudo docker ps -a|grep postgresql|wc -l`
#check_docker_ps=`sudo docker ps -a`
#echo $check_docker_ps
echo "message: $check_running_container_postgre"
#echo $check_running_container_postgre
#echo $check_running_container_postgre_dncSP
if [ $check_running_container_postgre -eq 1 ] && [ $check_running_container_postgre_dncSP -eq 1 ];
        then echo "Will you keep the old data? [y/n]"
        read k
        if [ "$k" = "y" ]; then
                check_nuclias_connect_POSTGRES_DATA=`sudo docker volume ls|grep nuclias_connect_POSTGRES_DATA|wc -l`
                if [ $check_nuclias_connect_POSTGRES_DATA -eq 1 ]
                        then
                        echo "The data volume already exists"
                        echo "Start deleting postgres:16.1"
                        postgre_container_id=`sudo docker ps -a|grep postgresql|cut -c 1-12`
                        sudo docker stop $postgre_container_id
                        sudo docker rm $postgre_container_id
                        sudo docker rmi postgres:16.1
                fi
        elif [ "$k" = "n" ]; then
                echo "Start deleting the data volume"
                check_nuclias_connect_POSTGRES_DATA=`sudo docker volume ls|grep nuclias_connect_POSTGRES_DATA|wc -l`
                if [ $check_nuclias_connect_POSTGRES_DATA -eq 1 ]
                        then
                        sudo docker volume rm nuclias_connect_POSTGRES_DATA
                fi
        fi
else
        echo -e "\033[32mno such old postgreDB contianer\033[0m"
fi


echo -e "\033[36m(7/11)---- check DB image ----\033[0m"
check_image_postgre=`sudo docker images postgres:16.1 | wc -l`
echo "message: $check_image_postgre"
if [ $check_image_postgre -eq 1 ]
	then echo "start find postgreSQL image"
	if [ ! -f $SHELL_FOLDER"/images/postgredb.tar" ]
		then echo -e "\033[31m not found postgreSQL image\033[0m"
		exit 1
	fi
load_postgre=`sudo docker load < $SHELL_FOLDER/images/postgredb.tar`
fi
echo -e "\033[32mpostgreSQL image is existed\033[0m"




echo -e "\033[36m(8/11)---- check postgreSQL_port ----\033[0m"
for port in 5432 5433
do
	check_postgre_port_free=`lsof -i:$port | wc -l`
	echo "message: $check_postgre_port_free"
	if [ $check_postgre_port_free -eq 0 ]
		then echo -e "\033[32mpostgre_port $port is free\033[0m"
	else
		echo -e "\033[31mpostgre_port $port is used\033[0m" 
		exit 1
	fi
done


echo -e "\033[36m(9/11)---- check web_port ----\033[0m"
check_web_port_free=`lsof -i:$web_port | wc -l`
echo "message: $check_web_port_free"
if [ $check_web_port_free -eq 0 ]
	then echo -e "\033[32mweb_port is free"
else
	echo -e "\033[31mweb_port:$web_port is used\033[0m" 
	exit 1
fi

echo -e "\033[36m(10/11)---- check core_port ----\033[0m"
check_core_port_free=`lsof -i:$core_port | wc -l`
echo "message: $check_core_port_free"
if [ $check_core_port_free -eq 0 ]
	then echo -e "\033[32mcore_port is free\033[0m"
else
	echo -e "\033[31mweb_port:$core_port is used\033[0m" 
	exit 1
fi


echo -e "\033[36m(11/11)---- check file and directory ----\033[0m"
if [ ! -f $SHELL_FOLDER"/docker-compose.yml" ]
	then echo -e "\033[31m not found docker-compose.yml\033[0m"
	exit 1
elif [ ! -f $SHELL_FOLDER"/appconfig.json" ]; then
	echo -e "\033[31mnot found appconfig.json\033[0m"
	exit 1
elif [ ! -f $SHELL_FOLDER"/config/systemconfig.json" ]; then
	echo -e "\033[31mnot found /config/systemconfig.json\033[0m"
	exit 1
elif [ ! -f $SHELL_FOLDER"/entrypoint-initdb.sql" ]; then
	echo -e "\033[31mnot found entrypoint-initdb.sql\033[0m"
	exit 1
fi
if [ ! -d $SHELL_FOLDER"/customer" ]; then
	mkdir $SHELL_FOLDER"/customer"
fi
# if [[ ! -d $SHELL_FOLDER"/data" ]]; then
# 	mkdir $SHELL_FOLDER"/data"
# fi
if [ ! -d $SHELL_FOLDER"/log/core/logs" ]; then
		if [ ! -d $SHELL_FOLDER"/log" ]; then
			mkdir $SHELL_FOLDER"/log"
		fi
		if [ ! -d $SHELL_FOLDER"/log/core" ]; then
			mkdir $SHELL_FOLDER"/log/core"
		fi
		if [ ! -d $SHELL_FOLDER"/log/core/logFiles" ]; then
			mkdir $SHELL_FOLDER"/log/core/logFiles"
		fi
fi
if [ ! -d $SHELL_FOLDER"/log/web/logs" ]; then
		if [ ! -d $SHELL_FOLDER"/log/web" ]; then
			mkdir $SHELL_FOLDER"/log/web"
		fi
		if [ ! -d $SHELL_FOLDER"/log/web/logFiles" ]; then
			mkdir $SHELL_FOLDER"/log/web/logFiles"
		fi
fi
sed -i "3c \  \"nucliasPath\":\""$SHELL_FOLDER"\"," $SHELL_FOLDER"/config/systemconfig.json"
echo -e "\033[32mcheck file finished\033[0m"
echo -e "\033[32mall check_job finished\033[0m"

check_nuclias_connect_POSTGRES_DATA=`sudo docker volume ls|grep nuclias_connect_POSTGRES_DATA|wc -l`
if [ $check_nuclias_connect_POSTGRES_DATA -eq 0 ]
	then  
		echo ""
		echo -e "\033[36mThe system will initial setup the database administrator account for Nuclias Connect, is this the first time to setup an administrator account? [y/n]\033[0m"
		read k
		if [ "$k" = "y" ];then
			read -p "User Name：" name
			if [ -n "$name" ]; then 
				read -p "Password：" pwd1
				if [ -n "$pwd1" ]; then
						read -p "Confirm Password：" pwd2
						if [ "$pwd1" != "$pwd2" ]; then
							echo -e "\033[31mConfirm password is not consistent\033[0m"
							exit 1
						else
							sed -i "s/POSTGRES_USER: 'admin'/POSTGRES_USER: '$name'/g" $SHELL_FOLDER"/docker-compose.yml"
							sed -i "s/POSTGRES_PASSWORD: 'admin'/POSTGRES_PASSWORD: '$pwd2'/g" $SHELL_FOLDER"/docker-compose.yml"
						fi
				else
					echo -e "\033[31mThe input password is empty\033[0m"
					exit 1
				fi
			else
				echo -e "\033[31mThe input user name is empty\033[0m"
				exit 1
			fi
		fi
fi


docker-compose up -d

# Modify docker.service
if grep -q 'ExecStart=\/usr\/bin\/dockerd -H fd:\/\/ --containerd=\/run\/containerd\/containerd.sock --default-ulimit core=0:0' /lib/systemd/system/docker.service; then
	:
else
	sudo sed -i 's/ExecStart=\/usr\/bin\/dockerd -H fd:\/\/ --containerd=\/run\/containerd\/containerd.sock/ExecStart=\/usr\/bin\/dockerd -H fd:\/\/ --containerd=\/run\/containerd\/containerd.sock --default-ulimit core=0:0/g' /lib/systemd/system/docker.service
fi
# Reload daemon
sudo systemctl daemon-reload
# Restart docker
sudo systemctl restart docker

echo -e "\033[32mNuclias Connect services are running...\033[0m"
echo ""
echo "-- commands list -----------------------"
echo "|                                       |"
echo -e "|  start: \033[32mdocker-compose up -d\033[0m          |"
echo -e "|  stop:: \033[32mdocker-compose down\033[0m           |"
echo "|                                       |"
echo " ----------------------------------------"
exit 0





