#!/usr/bin/env bash
hyper_port=30003
web_port=30001
core_port=8443
SHELL_FOLDER=$(cd "$(dirname "$0")";pwd)
                                                                                                                        
                                                                                                                        
echo "                                                                                                                        

                                                                                                                        
                                                                                                                        
           !@@@@@@@@@@@@@@@~                                                                                            
          !@@@@@@@@@@@@@@@@@@             #@@@@@@@@@@@@@        =@@@@                         !@@@@@,                   
          @@@@@@@@@@@@@@@@@@@@            @@@@@@@@@@@@@!       ;@@@@@@                      @@@@@@@@,                   
            @@@@@@@@   =@@@@@@@             @@@@@@@@!,        @@@@@@@                     ,@@@@@@@@.                   
            @@@@@@@@    @@@@@@@!             @@@@@@@           @@@@@@:                        @@@@@@.                   
            @@@@@@@@     @@@@@@@             @@@@@@@          ;@@@@@.                         @@@@@@.                   
            @@@@@@@@     :@@@@@@@            @@@@@@@                                          @@@@@@.                   
            @@@@@@@@      @@@@@@@~           @@@@@@@              !@@       @@!     ;@@!      @@@@@@.    #@@@@@@,       
            @@@@@@@@      .@@@@@@@           @@@@@@@          .@@@@@@    @@@@@@   @@@@@@@     @@@@@@.   @@@@@@@:        
            @@@@@@@@       @@@@@@@;          @@@@@@@          @@@@@@@   @@@@@@@-@@@@@@@@@     @@@@@@   @@@@@@           
            @@@@@@@@        @@@@@@@ @@@@@@@  @@@@@@@          .@@@@@@   ,@@@@@@@@@@@@@@@@     @@@@@@. @@@@@@            
            @@@@@@@@       .@@@@@@@ @@@@@@@  @@@@@@@            @@@@@    @@@@@@@.  .@@@@@     @@@@@@.@@@@@@.            
            @@@@@@@@       @@@@@@@  @@@@@@@  @@@@@@@            @@@@@    @@@@@@     @@@@@     @@@@@@@@@@@@!             
            @@@@@@@@       @@@@@@@  #######  @@@@@@@      ;@$   @@@@@    @@@@@@     @@@@@     @@@@@@@@@@@@!             
            @@@@@@@@      @@@@@@@.           @@@@@@@      @@$   @@@@@    @@@@@@     @@@@@     @@@@@@@@@@@@@-            
            @@@@@@@@     #@@@@@@@            @@@@@@@     @@@$   @@@@@    @@@@@@     @@@@@     @@@@@@-@@@@@@@            
            @@@@@@@@    ~@@@@@@@             @@@@@@@     @@@$   @@@@@    @@@@@@     @@@@@     @@@@@@, @@@@@@@           
            @@@@@@@@    @@@@@@@@             @@@@@@@     @@@$   @@@@@    @@@@@@     @@@@@     @@@@@@,  @@@@@@@.         
          -@@@@@@@@@@@@@@@@@@@@              @@@@@@@@*!@@@@@$  /@@@@@@   @@@@@@.    @@@@@@    @@@@@@@-  @@@@@@@@-       
          @@@@@@@@@@@@@@@@@@@@~           @@@@@@@@@@@@@@@@@@$ @@@@@@@@@ @@@@@@@@@   @@@@@@@ @@@@@@@@@@   @@@@@@@@@      
         ;@@@@@@@@@@@@@@@@@@.            @@@@@@@@@@@@@@@@@@@/ @@@@@@@@@ @@@@@@@@@    #@@@@# @@@@@@@@@@    :@@@@@@.      
                                                                                                                        
                                                                                                                        "

echo "########## Welcome use Nuclias Hyper ###########"
echo "                     --                           "
echo "                     --                           "
echo "                     --                           "

#Uninstall automatically
echo -e "\033[36m(1/12)---- Uninstall the version ----\033[0m"
Check_hyper_versions=`sudo docker images|grep dlink/nuclias_hyper | awk '{print $2}' | head -n 1`
if [[ $Check_hyper_versions ]]
	then
		Check_versions=$Check_hyper_versions
		if [[ $Check_hyper_versions != '' ]]
			then 
				Check_versions=$Check_hyper_versions
		fi	
		echo -e "\033[32mNuclias Hyper $Check_versions has been installed.  
If you are going to reinstall it, remind you to back up the existing configuration file before starting. 
Would you like to continue the installation? [y/n] \033[0m"
	
		read k
		if [ "$k" = "n" ]
			then		
				echo -e "\033 [The installation process is canceled,please back up the existing configuration file you start again. \033[0m"
				exit 1	
		else
			echo "Please wait..."	
			check_container_hyper_id=`sudo docker ps -a |grep dlink/nuclias_hyper |cut -c 1-12|wc -l`
			echo "message: $check_container_hyper_id"
			if [ $check_container_hyper_id -eq 1 ]
				then
				echo "start delete nuclias hyper"			
				container_hyper_id=`sudo docker ps -a |grep dlink/nuclias_hyper |cut -c 1-12`			
				sudo docker stop $container_hyper_id 
				sudo docker rm $container_hyper_id
			fi
			
			check_container_core_id=`sudo docker ps -a |grep nuclias/nuclias_connect_core |cut -c 1-12|wc -l`
			echo "message: $check_container_core_id"
			if [ $check_container_core_id -eq 1 ]
				then
				echo "start delete core"					
				container_core_id=`sudo docker ps -a |grep nuclias/nuclias_connect_core |cut -c 1-12`
				sudo docker stop $container_core_id 		
				sudo docker rm $container_core_id		
			fi
			
			check_container_web_id=`sudo docker ps -a |grep nuclias/nuclias_connect_web |cut -c 1-12|wc -l`
			echo "message: $check_container_web_id"
			if [ $check_container_web_id -eq 1 ]
				then
				echo "start delete web"			
				container_web_id=`sudo docker ps -a |grep nuclias/nuclias_connect_web |cut -c 1-12`			
				sudo docker stop $container_web_id 
				sudo docker rm $container_web_id
			fi
			
			check_container_dv8_id=`sudo docker ps -a |grep m9203005/dview8-server-dev  |cut -c 1-12|wc -l`
			echo "message: $check_container_dv8_id"
			if [ $check_container_dv8_id -eq 1 ]
				then
				echo "start delete D-View 8"					
				container_dv8_id=`sudo docker ps -a |grep m9203005/dview8-server-dev  |cut -c 1-12`
				sudo docker stop $container_dv8_id 		
				sudo docker rm $container_dv8_id		
			fi
			
			check_container_postgredb_id=`sudo docker ps -a |grep postgres |cut -c 1-12|wc -l`
			echo "message: $check_container_postgredb_id"
			if [ $check_container_postgredb_id -eq 1 ]
				then
				echo "start delete postgreDB"					
				container_core_id=`sudo docker ps -a |grep postgres |cut -c 1-12`
				sudo docker stop $container_core_id 		
				sudo docker rm $container_core_id		
			fi
			
			docker-compose down
			
			#rm n hyper images
			check_image=`sudo docker images dlink/nuclias_hyper:$Check_versions | wc -l`
			echo "message: $check_image"
			if [ $check_image -eq 2 ]
				then echo "start uninstall Nuclias Hyper image"
				sudo docker rmi dlink/nuclias_hyper:$Check_versions #Delete core images
			else
				echo "No older versions of Nuclias Hyper image found"
			fi
			
			#rm nc images
			Check_core_vers=`sudo docker images|grep nuclias/nuclias_connect_core | awk '{print $2}' | head -n 1`
			Check_web_vers=`sudo docker images|grep nuclias/nuclias_connect_web | awk '{print $2}' | head -n 1`
			check_image_core=`sudo docker images nuclias/nuclias_connect_core:$Check_core_vers | wc -l`
			check_image_web=`sudo docker images nuclias/nuclias_connect_web:$Check_web_vers | wc -l`
			echo "message: $check_image_core"
			if [ $check_image_core -eq 2 ]
				then echo "start uninstall nc core image"
				sudo docker rmi nuclias/nuclias_connect_core:$Check_core_vers #Delete core images
			else
				echo "No older versions of nuclias_connect_core image found"
			fi

			echo "message: $check_image_web"
			if [ $check_image_web -eq 2 ]
				then echo "start uninstall nc web image"
				sudo docker rmi nuclias/nuclias_connect_web:$Check_web_vers  #Delete web images
			else
				echo "No older versions of nuclias_connect_web image found"
			fi
			
			#rm dv8 images
			Check_dv8_vers=`sudo docker images|grep m9203005/dview8-server-dev | awk '{print $2}' | head -n 1`
			check_image=`sudo docker images m9203005/dview8-server-dev:$Check_dv8_vers | wc -l`
			echo "message: $check_image"
			if [ $check_image -eq 2 ]
				then echo "start uninstall NMS image"
				sudo docker rmi m9203005/dview8-server-dev:$Check_dv8_vers #Delete core images
			else
				echo "No older versions of NMS image found"
			fi
				echo -e "\033[32mHas been completed\033[0m"
		fi
else
echo -e "\033[32mNo version installation detected \033[0m"
fi

echo -e "\033[36m(2/12)---- check Nuclias Hyper image ----\033[0m"
check_image_core=`sudo docker images dlink/nuclias_hyper | wc -l`
echo "message: $check_image_core"
if [ $check_image_core -eq 1 ]
	then echo "start down Nuclias Hyper image"
	if [ ! -f $SHELL_FOLDER"/images/NucliasHyper.tar" ]
		then echo -e "\033[31m not found Nuclias Hyper image\033[0m"
	exit 1
	fi
	load_core=`sudo docker load < $SHELL_FOLDER/images/NucliasHyper.tar`
fi
echo -e "\033[32mNuclias Hyper image is existed\033[0m"

echo -e "\033[36m(3/12)---- check NMS image ----\033[0m"
check_image_core=`sudo docker images m9203005/dview8-server-dev | wc -l`
echo "message: $check_image_core"
if [ $check_image_core -eq 1 ]
	then echo "start down NMS image"
	if [ ! -f $SHELL_FOLDER"/images/dv8.tar" ]
		then echo -e "\033[31m not found Dview8 image\033[0m"
	exit 1
	fi
	load_core=`sudo docker load < $SHELL_FOLDER/images/dv8.tar`
fi
echo -e "\033[32mNMS image is existed\033[0m"

echo -e "\033[36m(4/12)---- check core image ----\033[0m"
check_image_core=`sudo docker images nuclias/nuclias_connect_core | wc -l`
echo "message: $check_image_core"
if [ $check_image_core -eq 1 ]
	then echo "start down core image"
	if [ ! -f $SHELL_FOLDER"/images/core.tar" ]
		then echo -e "\033[31m not found core image\033[0m"
	exit 1
	fi
	load_core=`sudo docker load < $SHELL_FOLDER/images/core.tar`
fi
echo -e "\033[32mcore image is existed\033[0m"

echo -e "\033[36m(5/12)---- check web image ----\033[0m"
check_image_web=`sudo docker images nuclias/nuclias_connect_web | wc -l`
echo "message: $check_image_web"
if [ $check_image_web -eq 1 ]
	then echo "start down web image"
	if [ ! -f $SHELL_FOLDER"/images/web.tar" ]
		then echo -e "\033[31m not found core image\033[0m"
		exit 1
	fi
	load_web=`sudo docker load < $SHELL_FOLDER/images/web.tar`
fi
echo -e "\033[32mweb image is existed\033[0m"


echo -e "\033[36m(6/12)---- check old DB ----\033[0m"
check_running_container_postgre=`sudo docker ps -a|grep postgres:16.1|wc -l`
check_running_container_postgre_dncSP=`sudo docker ps -a|grep postgresql|wc -l`
#check_docker_ps=`sudo docker ps -a`
#echo $check_docker_ps
echo "message: $check_running_container_postgre"
#echo $check_running_container_postgre
#echo $check_running_container_postgre_dncSP
if [ $check_running_container_postgre -eq 1 ] && [ $check_running_container_postgre_dncSP -eq 1 ];
        then 
		echo "An old PostgreSQL database volume was found."
		echo "Do you want to keep the existing data? [y/n]"
        read k
        if [ "$k" = "y" ]; then
                check_nuclias_connect_POSTGRES_DATA=`sudo docker volume ls|grep nucliashyper_POSTGRES_DATA|wc -l`
                if [ $check_nuclias_connect_POSTGRES_DATA -eq 1 ]
                        then
                        echo "Keeping the data (PostgreSQL container will be restarted)"
                        postgre_container_id=`sudo docker ps -a|grep postgresql|cut -c 1-12`
                        sudo docker stop $postgre_container_id >/dev/null 2>&1
                        sudo docker rm $postgre_container_id >/dev/null 2>&1
                        #sudo docker rmi postgres:16.1 >/dev/null 2>&1
                fi
        elif [ "$k" = "n" ]; then
                echo "Deleting the old data (PostgreSQL volume is being removed and a new container will be started)"
				postgre_container_id=`sudo docker ps -a|grep postgresql|cut -c 1-12`
                #sudo docker stop $postgre_container_id >/dev/null 2>&1
                sudo docker rm -f $postgre_container_id >/dev/null 2>&1
                check_nuclias_connect_POSTGRES_DATA=`sudo docker volume ls|grep nucliashyper_POSTGRES_DATA|wc -l`
                if [ $check_nuclias_connect_POSTGRES_DATA -eq 1 ]
                        then
                        sudo docker volume rm nucliashyper_POSTGRES_DATA
                fi
        fi

fi



echo -e "\033[36m(7/12)---- check DB image ----\033[0m"
check_image_postgre=`sudo docker images postgres:16.1 | wc -l`
echo "message: $check_image_postgre"
if [ $check_image_postgre -eq 1 ]
	then echo "start find postgreSQL image"
	if [ ! -f $SHELL_FOLDER"/images/postgredb.tar" ]
		then echo -e "\033[31m not found postgreSQL image\033[0m"
		exit 1
	fi
load_postgre=`sudo docker load < $SHELL_FOLDER/images/postgredb.tar`
fi
echo -e "\033[32mpostgreSQL image is existed\033[0m"




echo -e "\033[36m(8/12)---- check postgreSQL_port ----\033[0m"
for port in 5432 5433
do
	check_postgre_port_free=`lsof -i:$port | wc -l`
	echo "message: $check_postgre_port_free"
	if [ $check_postgre_port_free -eq 0 ]
		then echo -e "\033[32mpostgre_port $port is free\033[0m"
	else
		echo -e "\033[31mpostgre_port $port is used\033[0m" 
		exit 1
	fi
done

echo -e "\033[36m(9/12)---- check hyper_port ----\033[0m"
check_hyper_port_free=`lsof -i:$hyper_port | wc -l`
echo "message: $check_hyper_port_free"
if [ $check_hyper_port_free -eq 0 ]
	then echo -e "\033[32mhyper_port is free"
else
	echo -e "\033[31mweb_port:$hyper_port is used\033[0m" 
	exit 1
fi

echo -e "\033[36m(10/12)---- check web_port ----\033[0m"
check_web_port_free=`lsof -i:$web_port | wc -l`
echo "message: $check_web_port_free"
if [ $check_web_port_free -eq 0 ]
	then echo -e "\033[32mweb_port is free"
else
	echo -e "\033[31mweb_port:$web_port is used\033[0m" 
	exit 1
fi

echo -e "\033[36m(11/12)---- check core_port ----\033[0m"
check_core_port_free=`lsof -i:$core_port | wc -l`
echo "message: $check_core_port_free"
if [ $check_core_port_free -eq 0 ]
	then echo -e "\033[32mcore_port is free\033[0m"
else
	echo -e "\033[31mweb_port:$core_port is used\033[0m" 
	exit 1
fi


echo -e "\033[36m(12/12)---- check file and directory ----\033[0m"
if [ ! -f $SHELL_FOLDER"/docker-compose.yml" ]
	then echo -e "\033[31m not found docker-compose.yml\033[0m"
	exit 1
elif [ ! -f $SHELL_FOLDER"/config/nucliasHyperSystemconfig.json" ]; then
	echo -e "\033[31mnot found /config/nucliasHyperSystemconfig.json\033[0m"
	exit 1
elif [ ! -f $SHELL_FOLDER"/config/nucliasConnectAppconfig.json" ]; then
	echo -e "\033[31mnot found /config/nucliasConnectAppconfig.json\033[0m"
	exit 1
elif [ ! -f $SHELL_FOLDER"/config/nucliasConnectSystemconfig.json" ]; then
	echo -e "\033[31mnot found /config/nucliasConnectSystemconfig.json\033[0m"
	exit 1
fi
if [ ! -d $SHELL_FOLDER"/customer" ]; then
	mkdir $SHELL_FOLDER"/customer"
fi
# if [[ ! -d $SHELL_FOLDER"/data" ]]; then
# 	mkdir $SHELL_FOLDER"/data"
# fi
if [ ! -d $SHELL_FOLDER"/log/core/logs" ]; then
		if [ ! -d $SHELL_FOLDER"/log" ]; then
			mkdir $SHELL_FOLDER"/log"
		fi
		if [ ! -d $SHELL_FOLDER"/log/core" ]; then
			mkdir $SHELL_FOLDER"/log/core"
		fi
		if [ ! -d $SHELL_FOLDER"/log/core/logFiles" ]; then
			mkdir $SHELL_FOLDER"/log/core/logFiles"
		fi
fi
if [ ! -d $SHELL_FOLDER"/log/web/logs" ]; then
		if [ ! -d $SHELL_FOLDER"/log/web" ]; then
			mkdir $SHELL_FOLDER"/log/web"
		fi
		if [ ! -d $SHELL_FOLDER"/log/web/logFiles" ]; then
			mkdir $SHELL_FOLDER"/log/web/logFiles"
		fi
fi
sed -i "3c \  \"nucliasPath\":\""$SHELL_FOLDER"\"," $SHELL_FOLDER"/config/nucliasHyperSystemconfig.json"
echo -e "\033[32mcheck file finished\033[0m"
echo -e "\033[32mall check_job finished\033[0m"

check_nuclias_connect_POSTGRES_DATA=`sudo docker volume ls|grep nuclias_connect_POSTGRES_DATA|wc -l`
if [ $check_nuclias_connect_POSTGRES_DATA -eq 0 ]
	then  
		echo ""
		echo -e "\033[36mThe system will initial setup the database administrator account for Nuclias Connect, is this the first time to setup an administrator account? [y/n]\033[0m"
		read k
		if [ "$k" = "y" ];then
			read -p "User Name：" name
			if [ -n "$name" ]; then 
				read -p "Password：" pwd1
				if [ -n "$pwd1" ]; then
						read -p "Confirm Password：" pwd2
						if [ "$pwd1" != "$pwd2" ]; then
							echo -e "\033[31mConfirm password is not consistent\033[0m"
							exit 1
						else
							sed -i "s/POSTGRES_USER: 'admin'/POSTGRES_USER: '$name'/g" $SHELL_FOLDER"/docker-compose.yml"
							sed -i "s/POSTGRES_PASSWORD: 'admin'/POSTGRES_PASSWORD: '$pwd2'/g" $SHELL_FOLDER"/docker-compose.yml"
						fi
				else
					echo -e "\033[31mThe input password is empty\033[0m"
					exit 1
				fi
			else
				echo -e "\033[31mThe input user name is empty\033[0m"
				exit 1
			fi
		fi
fi

# Prompt user for new IP
echo -e "\033[36mPlease enter the host IP address. This IP will be used for NMS features such as Configuration Backup/Restore, Firmware Upgrade, and Trap/Syslog host setup: \033[0m"
read NEW_IP
# Validate IP format
if [[ ! $NEW_IP =~ ^([0-9]{1,3}\.){3}[0-9]{1,3}$ ]]; then
  echo "Error: Please enter a valid IP address format (e.g., 192.168.1.100)."
  exit 1
fi

# Target file
TARGET_FILE="docker-compose.yml"

# Use appropriate sed syntax depending on OS
if [[ "$OSTYPE" == "darwin"* ]]; then
  # macOS
  sed -i '' "s/\(PANGU_HOST_SERVER_ADDRESS\s*:\s*\).*/\1$NEW_IP/" "$TARGET_FILE"
else
  # Linux
  sed -i "s/\(PANGU_HOST_SERVER_ADDRESS\s*:\s*\).*/\1$NEW_IP/" "$TARGET_FILE"
fi

docker-compose up -d

echo -e "\033[32mThe Nuclias Hyper services is still starting and will take 2–3 more minutes. Please wait patiently...\033[0m"
echo ""
echo "-- commands list -----------------------"
echo "|                                       |"
echo -e "|  start: \033[32mdocker-compose up -d\033[0m          |"
echo -e "|  stop:: \033[32mdocker-compose down\033[0m           |"
echo "|                                       |"
echo " ----------------------------------------"
exit 0





